/********************************************************************************************************************************************************
*  author: Michael Mandel (mmandel@apple.com)                                                                                                           *
*  created: 5/30/06                                                                                                                                     *
*  Implements the basic fixed function features of OpenGL we use in shaders - this is common code that may be shared between shaders.                   *
*  This relies on uniform parameters created by Coin and updated based on current openGL state, causing quite a few conditionals in the shader code...  *
*********************************************************************************************************************************************************/

uniform sampler2D texUnit0;

uniform int coin_HasSeparateSpecular;

void fixed_funcComputeFragColor()
{
    vec4 color;
    
    color = gl_Color;

    color *= texture2D(texUnit0, gl_TexCoord[0].xy);
    
    if(coin_HasSeparateSpecular == 1) {
        color += gl_SecondaryColor;
    }
     
    color = clamp(color, 0.0, 1.0);
    
    gl_FragColor = color;
}
